/*
 * Decompiled with CFR 0.152.
 */
package verbiste;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Verbiste
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JToggleButton ancienBouttonSelectionn\u00e9 = null;
    private String ancienneRecherche = "";
    private JButton buttonEffacer;
    private ButtonGroup buttonGroup1;
    private JToggleButton buttonTous;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTextField labelTotal;
    private JList listVerbes;
    private JPanel panelCentre;
    private JPanel panelConditionnel;
    private JPanel panelConjugaison;
    private JPanel panelHaut;
    private JPanel panelImp\u00e9ratif;
    private JPanel panelIndicatif;
    private JPanel panelInitiale;
    private JPanel panelParticipe;
    private JPanel panelRecherche;
    private JPanel panelSubjonctif;
    private JTextField texteRecherche;
    private String[] verbes;
    private String[] verbesSansAccent;
    private Initiale[] initiales;
    private int indexInitialeSelected = -1;
    private final DefaultListModel listModelListeVerbesTous = new DefaultListModel();
    private final DefaultListModel listModelListeVerbes = new DefaultListModel();
    private boolean premierRemplissageFait = false;
    private final HashMap<Verbe.ModeTemps, JTextField[]> labelsModeTemps = new HashMap();
    private static final String CMD = "french-conjugator";
    String ancienRemplissage = "";

    private void setListeVerbes(DefaultListModel lm) {
        this.listVerbes.setModel(lm);
        this.labelTotal.setText("Total: " + this.listVerbes.getModel().getSize());
        this.listVerbes.setSelectedIndex(0);
    }

    public Verbiste() {
        this.initComponents();
        this.makeListesVerbes();
        this.makePanelsTemps();
        this.listVerbes.setSelectedIndex(0);
        this.remplirConjugaison();
        this.premierRemplissageFait = true;
        this.texteRecherche.requestFocusInWindow();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.panelHaut = new JPanel();
        this.panelInitiale = new JPanel();
        this.buttonTous = new JToggleButton();
        this.panelRecherche = new JPanel();
        this.jLabel1 = new JLabel();
        this.texteRecherche = new JTextField();
        this.buttonEffacer = new JButton();
        this.panelCentre = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listVerbes = new JList();
        this.jPanel2 = new JPanel();
        this.labelTotal = new JTextField();
        this.panelConjugaison = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.panelIndicatif = new JPanel();
        this.panelImp\u00e9ratif = new JPanel();
        this.panelConditionnel = new JPanel();
        this.panelSubjonctif = new JPanel();
        this.panelParticipe = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Verbiste");
        this.setLocation(new Point(25, 25));
        this.jPanel3.setLayout(new BorderLayout());
        this.panelHaut.setLayout(new GridLayout(2, 0));
        this.buttonGroup1.add(this.buttonTous);
        this.buttonTous.setSelected(true);
        this.buttonTous.setText("Tous");
        this.buttonTous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Verbiste.this.buttonTousActionPerformed(evt);
            }
        });
        this.panelInitiale.add(this.buttonTous);
        this.panelHaut.add(this.panelInitiale);
        this.panelRecherche.setLayout(new FlowLayout(0));
        this.jLabel1.setLabelFor(this.texteRecherche);
        this.jLabel1.setText("Rechercher: ");
        this.panelRecherche.add(this.jLabel1);
        this.texteRecherche.setColumns(16);
        this.texteRecherche.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Verbiste.this.texteRechercheKeyReleased(evt);
            }
        });
        this.panelRecherche.add(this.texteRecherche);
        this.buttonEffacer.setText("Effacer");
        this.buttonEffacer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Verbiste.this.buttonEffacerActionPerformed(evt);
            }
        });
        this.panelRecherche.add(this.buttonEffacer);
        this.panelHaut.add(this.panelRecherche);
        this.jPanel3.add((Component)this.panelHaut, "North");
        this.panelCentre.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.listVerbes.setSelectionMode(0);
        this.listVerbes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Verbiste.this.listVerbesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listVerbes);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0));
        this.labelTotal.setEditable(false);
        this.labelTotal.setBackground(this.jLabel1.getBackground());
        this.labelTotal.setForeground(this.jLabel1.getForeground());
        this.labelTotal.setText("jTextField1");
        this.labelTotal.setBorder(this.jLabel1.getBorder());
        this.jPanel2.add(this.labelTotal);
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.panelCentre.add((Component)this.jPanel1, "West");
        this.panelConjugaison.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel2.setFont(new Font("Lucida Grande", 1, 18));
        this.jLabel2.setText("Conjugaison");
        this.jPanel4.add(this.jLabel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.panelConjugaison.add((Component)this.jPanel4, gridBagConstraints);
        this.panelIndicatif.setBorder(BorderFactory.createTitledBorder(null, Verbe.Mode.Indicatif.toString(), 0, 0, new Font("Lucida Grande", 1, 13)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelConjugaison.add((Component)this.panelIndicatif, gridBagConstraints);
        this.panelImp\u00e9ratif.setBorder(BorderFactory.createTitledBorder(null, Verbe.Mode.Imp\u00e9ratif.toString(), 0, 0, new Font("Lucida Grande", 1, 13)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelConjugaison.add((Component)this.panelImp\u00e9ratif, gridBagConstraints);
        this.panelConditionnel.setBorder(BorderFactory.createTitledBorder(null, Verbe.Mode.Conditionnel.toString(), 0, 0, new Font("Lucida Grande", 1, 13)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelConjugaison.add((Component)this.panelConditionnel, gridBagConstraints);
        this.panelSubjonctif.setBorder(BorderFactory.createTitledBorder(null, Verbe.Mode.Subjonctif.toString(), 0, 0, new Font("Lucida Grande", 1, 13)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.panelConjugaison.add((Component)this.panelSubjonctif, gridBagConstraints);
        this.panelParticipe.setBorder(BorderFactory.createTitledBorder(null, Verbe.Mode.Participe.toString(), 0, 0, new Font("Lucida Grande", 1, 13)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panelConjugaison.add((Component)this.panelParticipe, gridBagConstraints);
        this.panelCentre.add((Component)this.panelConjugaison, "Center");
        this.jPanel3.add((Component)this.panelCentre, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
    }

    private void buttonTousActionPerformed(ActionEvent evt) {
        JToggleButton b = (JToggleButton)evt.getSource();
        if (b == this.ancienBouttonSelectionn\u00e9) {
            return;
        }
        this.ancienBouttonSelectionn\u00e9 = b;
        this.setCursor(new Cursor(3));
        if (b == this.buttonTous) {
            this.setListeVerbes(this.listModelListeVerbesTous);
            this.indexInitialeSelected = -1;
        } else {
            this.listModelListeVerbes.clear();
            this.indexInitialeSelected = Integer.parseInt(b.getName());
            Initiale initiale = this.initiales[this.indexInitialeSelected];
            for (int i = initiale.debut; i <= initiale.fin; ++i) {
                this.listModelListeVerbes.addElement(this.verbes[i]);
            }
            this.setListeVerbes(this.listModelListeVerbes);
        }
        this.setCursor(new Cursor(0));
    }

    private void texteRechercheKeyReleased(KeyEvent evt) {
        String recherche = this.supprimerAccents(this.texteRecherche.getText());
        if (!recherche.equals(this.ancienneRecherche)) {
            this.ancienneRecherche = recherche;
            if (recherche.length() == 0) {
                this.buttonTous.doClick();
            } else {
                JToggleButton initiale = this.buttonTous;
                char c = recherche.charAt(0);
                for (Initiale i : this.initiales) {
                    if (c != i.lettre) continue;
                    initiale = i.bouton;
                }
                if (initiale != this.buttonTous) {
                    initiale.doClick();
                }
                if (this.indexInitialeSelected != -1) {
                    int debut = -1;
                    int fin = -1;
                    for (int i = this.initiales[this.indexInitialeSelected].debut; i <= this.initiales[this.indexInitialeSelected].fin; ++i) {
                        if (!this.verbesSansAccent[i].startsWith(recherche)) continue;
                        if (debut == -1) {
                            debut = fin = i;
                            continue;
                        }
                        fin = i;
                    }
                    if (debut != -1) {
                        DefaultListModel<String> lm = new DefaultListModel<String>();
                        for (int i = debut; i <= fin; ++i) {
                            lm.addElement(this.verbes[i]);
                        }
                        this.setListeVerbes(lm);
                    }
                }
            }
        }
    }

    private void buttonEffacerActionPerformed(ActionEvent evt) {
        if (!this.texteRecherche.getText().equals("")) {
            this.texteRecherche.setText("");
            this.buttonTous.doClick();
        }
    }

    private void listVerbesValueChanged(ListSelectionEvent evt) {
        if (!this.listVerbes.isSelectionEmpty() && this.premierRemplissageFait) {
            this.remplirConjugaison();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new Verbiste().setVisible(true));
    }

    private String supprimerAccents(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
    }

    private void remplirConjugaison() {
        String verbeSelectionn\u00e9 = (String)this.listVerbes.getSelectedValue();
        if (this.ancienRemplissage.equals(verbeSelectionn\u00e9)) {
            return;
        }
        this.ancienRemplissage = verbeSelectionn\u00e9;
        Verbe verbe = new Verbe(verbeSelectionn\u00e9);
        for (Verbe.Mode m : Verbe.Mode.values()) {
            for (Verbe.Temps t : m.getTemps()) {
                Verbe.ModeTemps modeTemps = new Verbe.ModeTemps(m, t);
                for (int i = 0; i < Verbe.getModeTempsLength(m, t); ++i) {
                    this.labelsModeTemps.get(modeTemps)[i].setText(verbe.get(m, t)[i]);
                }
            }
        }
    }

    private void makePanelsTemps() {
        HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
        fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        JPanel[] panelsMode = new JPanel[Verbe.Mode.values().length];
        panelsMode[Verbe.Mode.Indicatif.ordinal()] = this.panelIndicatif;
        panelsMode[Verbe.Mode.Imp\u00e9ratif.ordinal()] = this.panelImp\u00e9ratif;
        panelsMode[Verbe.Mode.Conditionnel.ordinal()] = this.panelConditionnel;
        panelsMode[Verbe.Mode.Subjonctif.ordinal()] = this.panelSubjonctif;
        panelsMode[Verbe.Mode.Participe.ordinal()] = this.panelParticipe;
        for (Verbe.Mode mode : Verbe.Mode.values()) {
            for (Verbe.Temps temps : mode.getTemps()) {
                Verbe.ModeTemps modeTemps = new Verbe.ModeTemps(mode, temps);
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createTitledBorder(null, temps.toString(), 0, 0, new Font("Lucida Grande", 2, 13).deriveFont(fontAttributes)));
                panel.setLayout(new BoxLayout(panel, 1));
                panelsMode[mode.ordinal()].add(panel);
                this.labelsModeTemps.put(modeTemps, new JTextField[Verbe.getModeTempsLength(mode, temps)]);
                for (int i = 0; i < Verbe.getModeTempsLength(mode, temps); ++i) {
                    JTextField label = new JTextField();
                    label.setEditable(false);
                    label.setBackground(this.jLabel1.getBackground());
                    label.setForeground(this.jLabel1.getForeground());
                    label.setText("temps" + (i + 1));
                    label.setBorder(this.jLabel1.getBorder());
                    label.setColumns(mode == Verbe.Mode.Indicatif && (temps == Verbe.Temps.Imparfait || temps == Verbe.Temps.Pass\u00e9Simple) ? 20 : 25);
                    panel.add(label);
                    this.labelsModeTemps.get((Object)modeTemps)[i] = label;
                }
            }
        }
        this.pack();
    }

    private void makeListesVerbes() {
        try {
            ArrayList<String> listeVerbes = new ArrayList<String>();
            Process process = Runtime.getRuntime().exec("french-conjugator --all-infinitives");
            try (String[] sortie = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String s;
                while ((s = sortie.readLine()) != null) {
                    listeVerbes.add(s);
                }
            }
            process.destroy();
            this.verbes = listeVerbes.toArray(new String[0]);
            Arrays.sort(this.verbes, Collator.getInstance(Locale.FRENCH));
            for (String s : this.verbes) {
                this.listModelListeVerbesTous.addElement(s);
            }
            this.setListeVerbes(this.listModelListeVerbesTous);
        }
        catch (IOException ex) {
            Logger.getLogger(Verbiste.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.verbesSansAccent = new String[this.verbes.length];
        for (int i = 0; i < this.verbes.length; ++i) {
            this.verbesSansAccent[i] = this.supprimerAccents(this.verbes[i]);
        }
        ArrayList<Initiale> listeInitiales = new ArrayList<Initiale>();
        Initiale vide = new Initiale();
        vide.fin = 0;
        vide.debut = 0;
        vide.lettre = (char)48;
        listeInitiales.add(vide);
        for (int i = 0; i < this.verbesSansAccent.length; ++i) {
            char lettre = this.verbesSansAccent[i].charAt(0);
            if (lettre == ((Initiale)listeInitiales.get((int)(listeInitiales.size() - 1))).lettre) {
                ((Initiale)listeInitiales.get((int)(listeInitiales.size() - 1))).fin = i;
                continue;
            }
            Initiale initiale = new Initiale();
            initiale.debut = initiale.fin = i;
            initiale.lettre = lettre;
            listeInitiales.add(initiale);
        }
        listeInitiales.remove(0);
        this.initiales = listeInitiales.toArray(new Initiale[0]);
        int[] widths = this.buttonTous.getFontMetrics(this.buttonTous.getFont()).getWidths();
        int max = 0;
        for (int n : widths) {
            if (n <= max) continue;
            max = n;
        }
        max += 4;
        for (int i = 0; i < this.initiales.length; ++i) {
            JToggleButton buttonLettre;
            this.initiales[i].bouton = buttonLettre = new JToggleButton();
            this.buttonGroup1.add(buttonLettre);
            buttonLettre.setText("" + this.initiales[i].lettre);
            this.panelInitiale.add(buttonLettre);
            buttonLettre.setName("" + i);
            buttonLettre.setFont(this.buttonTous.getFont());
            Dimension d = buttonLettre.getPreferredSize();
            d.width = max;
            buttonLettre.setPreferredSize(d);
            buttonLettre.addActionListener(evt -> this.buttonTousActionPerformed(evt));
        }
        this.pack();
    }

    public static class Verbe {
        private HashMap<String, String[]> conjugaison = new HashMap();
        private static BufferedReader sortie;
        private static OutputStreamWriter entree;

        public Verbe(String verbe) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                String s;
                entree.write(verbe + '\n');
                entree.flush();
                boolean participePass\u00e9Atteind = false;
                while (!(s = sortie.readLine()).equals("-") || !participePass\u00e9Atteind) {
                    list.add(s);
                    if (!s.equals("- " + Verbe.getNomCMD(Mode.Participe, Temps.Pass\u00e9) + ":")) continue;
                    participePass\u00e9Atteind = true;
                }
                list.add(s);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            for (Mode m : Mode.values()) {
                for (Temps t : m.getTemps()) {
                    int debut = -1;
                    int fin = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        if (((String)list.get(i)).startsWith("- " + m.getNomCMD() + " " + t.getNomCMD())) {
                            if (debut != -1) continue;
                            debut = i + 1;
                            continue;
                        }
                        if (debut == -1 || !((String)list.get(i)).startsWith("-")) continue;
                        fin = i - 1;
                        break;
                    }
                    ArrayList tempsDeriv\u00e9 = new ArrayList();
                    for (int i = debut; i <= fin; ++i) {
                        tempsDeriv\u00e9.add(list.get(i));
                    }
                    this.conjugaison.put(m.getNomCMD() + " " + t.getNomCMD(), tempsDeriv\u00e9.toArray(new String[0]));
                }
            }
        }

        public String[] get(Mode mode, Temps temps) {
            return this.conjugaison.get(Verbe.getNomCMD(mode, temps));
        }

        public static String getNomFran\u00e7ais(Mode mode, Temps temps) {
            return (Object)((Object)mode) + " " + (Object)((Object)temps);
        }

        private static String getNomCMD(Mode mode, Temps temps) {
            return mode.getNomCMD() + " " + temps.getNomCMD();
        }

        public static int getModeTempsLength(Mode mode, Temps temps) {
            if (mode.equals((Object)Mode.Imp\u00e9ratif)) {
                return 3;
            }
            if (mode.equals((Object)Mode.Participe) && temps.equals((Object)Temps.Pr\u00e9sent)) {
                return 1;
            }
            if (mode.equals((Object)Mode.Participe) && temps.equals((Object)Temps.Pass\u00e9)) {
                return 4;
            }
            return 6;
        }

        static {
            try {
                String cmd = "french-conjugator --pronouns ";
                Process process = Runtime.getRuntime().exec(cmd);
                sortie = new BufferedReader(new InputStreamReader(process.getInputStream()));
                entree = new OutputStreamWriter(process.getOutputStream());
            }
            catch (IOException ex) {
                Logger.getLogger(Verbiste.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public static class ModeTemps {
            public Mode mode;
            public Temps temps;

            public ModeTemps(Mode mode, Temps temps) {
                this.mode = mode;
                this.temps = temps;
            }

            public boolean equals(Object o) {
                if (o == null || !(o instanceof ModeTemps)) {
                    return false;
                }
                ModeTemps mt = (ModeTemps)o;
                return mt.mode == this.mode && mt.temps == this.temps;
            }

            public int hashCode() {
                int hash = 7;
                hash = 53 * hash + Objects.hashCode((Object)this.mode);
                hash = 53 * hash + Objects.hashCode((Object)this.temps);
                return hash;
            }
        }

        public static enum Temps {
            Pr\u00e9sent{

                @Override
                String getNomCMD() {
                    return "present";
                }
            }
            ,
            Imparfait{

                @Override
                String getNomCMD() {
                    return "imperfect";
                }
            }
            ,
            Pass\u00e9Simple{

                public String toString() {
                    return "Pass\u00e9 simple";
                }

                @Override
                String getNomCMD() {
                    return "past";
                }
            }
            ,
            Futur{

                @Override
                String getNomCMD() {
                    return "future";
                }
            }
            ,
            Pass\u00e9{

                @Override
                String getNomCMD() {
                    return "past";
                }
            };


            String getNomCMD() {
                return null;
            }
        }

        public static enum Mode {
            Indicatif{

                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Pr\u00e9sent, Temps.Imparfait, Temps.Pass\u00e9Simple, Temps.Futur};
                }

                @Override
                String getNomCMD() {
                    return "indicative";
                }
            }
            ,
            Conditionnel{

                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Pr\u00e9sent};
                }

                @Override
                String getNomCMD() {
                    return "conditional";
                }
            }
            ,
            Subjonctif{

                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Pr\u00e9sent, Temps.Imparfait};
                }

                @Override
                String getNomCMD() {
                    return "subjunctive";
                }
            }
            ,
            Imp\u00e9ratif{

                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Pr\u00e9sent};
                }

                @Override
                String getNomCMD() {
                    return "imperative";
                }
            }
            ,
            Participe{

                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Pr\u00e9sent, Temps.Pass\u00e9};
                }

                @Override
                String getNomCMD() {
                    return "participle";
                }
            };


            Temps[] getTemps() {
                return null;
            }

            String getNomCMD() {
                return null;
            }
        }
    }

    private class Initiale {
        char lettre;
        int debut;
        int fin;
        JToggleButton bouton;

        private Initiale() {
        }
    }
}

