/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

 /*
 * Verbiste.java
 *
 * Created on 15 juil. 2016, 18:24:13
 */
package verbiste;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

/**
 *
 * @author bruno
 */
public class Verbiste extends javax.swing.JFrame {

    private final static long serialVersionUID = 1;

    private void setListeVerbes(DefaultListModel lm) {
        listVerbes.setModel(lm);
        labelTotal.setText("Total: " + listVerbes.getModel().getSize());
        listVerbes.setSelectedIndex(0);
    }

    private class Initiale {

        char lettre;
        int debut, fin;
        JToggleButton bouton;
    }

    /**
     * Creates new form Verbiste
     */
    public Verbiste() {
        initComponents();

        makeListesVerbes();
        makePanelsTemps();
        listVerbes.setSelectedIndex(0);
        remplirConjugaison();
        premierRemplissageFait = true;
        texteRecherche.requestFocusInWindow(); // il faut le faire juste avant le setVisible() sur le JFrame

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel3 = new javax.swing.JPanel();
        panelHaut = new javax.swing.JPanel();
        panelInitiale = new javax.swing.JPanel();
        buttonTous = new javax.swing.JToggleButton();
        panelRecherche = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        texteRecherche = new javax.swing.JTextField();
        buttonEffacer = new javax.swing.JButton();
        panelCentre = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        listVerbes = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        labelTotal = new javax.swing.JTextField();
        panelConjugaison = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        panelIndicatif = new javax.swing.JPanel();
        panelImpératif = new javax.swing.JPanel();
        panelConditionnel = new javax.swing.JPanel();
        panelSubjonctif = new javax.swing.JPanel();
        panelParticipe = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Verbiste");
        setLocation(new java.awt.Point(25, 25));

        jPanel3.setLayout(new java.awt.BorderLayout());

        panelHaut.setLayout(new java.awt.GridLayout(2, 0));

        buttonGroup1.add(buttonTous);
        buttonTous.setSelected(true);
        buttonTous.setText("Tous");
        buttonTous.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonTousActionPerformed(evt);
            }
        });
        panelInitiale.add(buttonTous);

        panelHaut.add(panelInitiale);

        panelRecherche.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel1.setLabelFor(texteRecherche);
        jLabel1.setText("Rechercher: ");
        panelRecherche.add(jLabel1);

        texteRecherche.setColumns(16);
        texteRecherche.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                texteRechercheKeyReleased(evt);
            }
        });
        panelRecherche.add(texteRecherche);

        buttonEffacer.setText("Effacer");
        buttonEffacer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonEffacerActionPerformed(evt);
            }
        });
        panelRecherche.add(buttonEffacer);

        panelHaut.add(panelRecherche);

        jPanel3.add(panelHaut, java.awt.BorderLayout.NORTH);

        panelCentre.setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new java.awt.BorderLayout());

        listVerbes.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        listVerbes.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                listVerbesValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(listVerbes);

        jPanel1.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        labelTotal.setEditable(false);
        labelTotal.setBackground(jLabel1.getBackground());
        labelTotal.setForeground(jLabel1.getForeground());
        labelTotal.setText("jTextField1");
        labelTotal.setBorder(jLabel1.getBorder());
        jPanel2.add(labelTotal);

        jPanel1.add(jPanel2, java.awt.BorderLayout.SOUTH);

        panelCentre.add(jPanel1, java.awt.BorderLayout.WEST);

        panelConjugaison.setLayout(new java.awt.GridBagLayout());

        jPanel4.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jLabel2.setFont(new java.awt.Font("Lucida Grande", 1, 18)); // NOI18N
        jLabel2.setText("Conjugaison");
        jPanel4.add(jLabel2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        panelConjugaison.add(jPanel4, gridBagConstraints);

        panelIndicatif.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Verbe.Mode.Indicatif.toString(), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Lucida Grande", 1, 13))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        panelConjugaison.add(panelIndicatif, gridBagConstraints);

        panelImpératif.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Verbe.Mode.Impératif.toString(), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Lucida Grande", 1, 13))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        panelConjugaison.add(panelImpératif, gridBagConstraints);

        panelConditionnel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Verbe.Mode.Conditionnel.toString(), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Lucida Grande", 1, 13))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 0);
        panelConjugaison.add(panelConditionnel, gridBagConstraints);

        panelSubjonctif.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Verbe.Mode.Subjonctif.toString(), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Lucida Grande", 1, 13))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 5);
        panelConjugaison.add(panelSubjonctif, gridBagConstraints);

        panelParticipe.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Verbe.Mode.Participe.toString(), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Lucida Grande", 1, 13))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        panelConjugaison.add(panelParticipe, gridBagConstraints);

        panelCentre.add(panelConjugaison, java.awt.BorderLayout.CENTER);

        jPanel3.add(panelCentre, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel3, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private javax.swing.JToggleButton ancienBouttonSelectionné = null;

    /**
     * Gère le boutton "Tous" et tous les boutons de lettre (initiales des
     * verbes existants)
     */
    private void buttonTousActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonTousActionPerformed
        javax.swing.JToggleButton b = (javax.swing.JToggleButton) evt.getSource();
        if (b == ancienBouttonSelectionné) {
            return;
        }
        ancienBouttonSelectionné = b;
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        if (b == buttonTous) {
            setListeVerbes(listModelListeVerbesTous);
            indexInitialeSelected = -1;
        }
        else {
            listModelListeVerbes.clear();
            indexInitialeSelected = Integer.parseInt(b.getName());
            Initiale initiale = initiales[indexInitialeSelected];
            for (int i = initiale.debut; i <= initiale.fin; i++) {
                listModelListeVerbes.addElement(verbes[i]);
            }
            setListeVerbes(listModelListeVerbes);
        }
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_buttonTousActionPerformed

    private String ancienneRecherche = "";
    private void texteRechercheKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_texteRechercheKeyReleased

        String recherche = supprimerAccents(texteRecherche.getText());
        if (!recherche.equals(ancienneRecherche)) {
            ancienneRecherche = recherche;
            if (recherche.length() == 0) {
                buttonTous.doClick();
            }
            else {
                JToggleButton initiale = buttonTous;
                char c = recherche.charAt(0);
                for (Initiale i : initiales) {
                    if (c == i.lettre) {
                        initiale = i.bouton;
                    }
                }
                if (initiale != buttonTous) {
                    initiale.doClick();
                }
                if (indexInitialeSelected != -1) { // -1 se produit si la 1ère lettre du champ n'est pas une initiale existante
                    int debut = -1;
                    int fin = -1;
                    for (int i = initiales[indexInitialeSelected].debut; i <= initiales[indexInitialeSelected].fin; i++) {
                        if (verbesSansAccent[i].startsWith(recherche)) {
                            if (debut == -1) {
                                debut = fin = i;
                            }
                            else {
                                fin = i;
                            }
                        }
                    }
                    if (debut != -1) {
                        DefaultListModel lm = new DefaultListModel();
                        for (int i = debut; i <= fin; i++) {
                            lm.addElement(verbes[i]);
                        }
                        setListeVerbes(lm);
                    }
                }
            }
        }
    }//GEN-LAST:event_texteRechercheKeyReleased

    private void buttonEffacerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonEffacerActionPerformed
        if (!texteRecherche.getText().equals("")) {
            texteRecherche.setText("");
            buttonTous.doClick();
        }
    }//GEN-LAST:event_buttonEffacerActionPerformed

    private void listVerbesValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_listVerbesValueChanged

        if ((!listVerbes.isSelectionEmpty()) && (premierRemplissageFait)) {
            remplirConjugaison();
        }

    }//GEN-LAST:event_listVerbesValueChanged

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(() -> {
            new Verbiste().setVisible(true);
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonEffacer;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JToggleButton buttonTous;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField labelTotal;
    private javax.swing.JList listVerbes;
    private javax.swing.JPanel panelCentre;
    private javax.swing.JPanel panelConditionnel;
    private javax.swing.JPanel panelConjugaison;
    private javax.swing.JPanel panelHaut;
    private javax.swing.JPanel panelImpératif;
    private javax.swing.JPanel panelIndicatif;
    private javax.swing.JPanel panelInitiale;
    private javax.swing.JPanel panelParticipe;
    private javax.swing.JPanel panelRecherche;
    private javax.swing.JPanel panelSubjonctif;
    private javax.swing.JTextField texteRecherche;
    // End of variables declaration//GEN-END:variables

    private String[] verbes;
    private String[] verbesSansAccent;

    private Initiale[] initiales;
    /**
     * Si ==-1 c'est le bouton "Tous"
     */
    private int indexInitialeSelected = -1;

    /**
     * Il faut conserver cette liste pour optimiser les perfomances
     */
    private final DefaultListModel listModelListeVerbesTous = new DefaultListModel(); // mappé sur listeVerbes dans le designer
    private final DefaultListModel listModelListeVerbes = new DefaultListModel();

    private boolean premierRemplissageFait = false;
    private final HashMap<Verbe.ModeTemps, JTextField[]> labelsModeTemps = new HashMap<>();

    private static final String CMD = "french-conjugator";

    private String supprimerAccents(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("[\u0300-\u036F]", "");
    }

    String ancienRemplissage = "";

    private void remplirConjugaison() {
        // on vérifie que le remplissage est un nouveau verbe
        String verbeSelectionné = (String) listVerbes.getSelectedValue();
        if (ancienRemplissage.equals(verbeSelectionné)) {
            return;
        }
        ancienRemplissage = verbeSelectionné;

        Verbe verbe = new Verbe(verbeSelectionné);
        for (Verbe.Mode m : Verbe.Mode.values()) {
            for (Verbe.Temps t : m.getTemps()) {
                Verbe.ModeTemps modeTemps = new Verbe.ModeTemps(m, t);
                for (int i = 0; i < Verbe.getModeTempsLength(m, t); i++) {
                    labelsModeTemps.get(modeTemps)[i].setText(verbe.get(m, t)[i]);
                }
            }
        }
    }

    private void makePanelsTemps() {

        // Pour faire une fonte soulignée
        Map<TextAttribute, Integer> fontAttributes = new HashMap<>();
        fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);

        JPanel panelsMode[] = new JPanel[Verbe.Mode.values().length];
        panelsMode[Verbe.Mode.Indicatif.ordinal()] = panelIndicatif;
        panelsMode[Verbe.Mode.Impératif.ordinal()] = panelImpératif;
        panelsMode[Verbe.Mode.Conditionnel.ordinal()] = panelConditionnel;
        panelsMode[Verbe.Mode.Subjonctif.ordinal()] = panelSubjonctif;
        panelsMode[Verbe.Mode.Participe.ordinal()] = panelParticipe;
        for (Verbe.Mode mode : Verbe.Mode.values()) {
            for (Verbe.Temps temps : mode.getTemps()) {
                Verbe.ModeTemps modeTemps = new Verbe.ModeTemps(mode, temps);
                JPanel panel = new JPanel();
                panel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, temps.toString(), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new Font("Lucida Grande", java.awt.Font.ITALIC, 13).deriveFont(fontAttributes)));
                panel.setLayout(new javax.swing.BoxLayout(panel, javax.swing.BoxLayout.Y_AXIS));
                panelsMode[mode.ordinal()].add(panel);
                labelsModeTemps.put(modeTemps, new JTextField[Verbe.getModeTempsLength(mode, temps)]);
                for (int i = 0; i < Verbe.getModeTempsLength(mode, temps); i++) {
                    JTextField label = new JTextField();
                    label.setEditable(false);
                    label.setBackground(jLabel1.getBackground());
                    label.setForeground(jLabel1.getForeground());
                    label.setText("temps" + (i + 1));
                    label.setBorder(jLabel1.getBorder());
                    label.setColumns(((mode == Verbe.Mode.Indicatif) && ((temps == Verbe.Temps.Imparfait) || (temps == Verbe.Temps.PasséSimple))) ? 20 : 25);
                    panel.add(label);
                    labelsModeTemps.get(modeTemps)[i] = label;
                }
            }
        }
        pack();
    }

    private void makeListesVerbes() {

        /*
            // bourrin mais lecteur de XML
            String filename = "/usr/local/share/verbiste-0.1/verbs-fr.xml";
            
            final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
            final DocumentBuilder builder = factory.newDocumentBuilder();
            final Document document = builder.parse(new File(filename));
            final Element racine = document.getDocumentElement();
            final NodeList racineNoeuds = racine.getChildNodes();
            final int nbRacineNoeuds = racineNoeuds.getLength();

            for (int i = 0; i < nbRacineNoeuds; i++) {
            if (racineNoeuds.item(i).getNodeType() == Node.ELEMENT_NODE) {
            listeVerbes.add(racineNoeuds.item(i).getFirstChild().getTextContent());
            }
            }
            for (String s : listeVerbes) {
            listModelListeVerbes.addElement(s);
            }
            } catch (SAXException ex) {
            Logger.getLogger(Verbiste.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
            Logger.getLogger(Verbiste.class.getName()).log(Level.SEVERE, null, ex);
            } catch (ParserConfigurationException ex) {
            Logger.getLogger(Verbiste.class.getName()).log(Level.SEVERE, null, ex);
            }
         */
        try {
            ArrayList<String> listeVerbes = new ArrayList<>();
            Process process = Runtime.getRuntime().exec(CMD + " --all-infinitives");
            try (BufferedReader sortie = new BufferedReader(new InputStreamReader(process.getInputStream()))) {
                String s;
                while ((s = sortie.readLine()) != null) {
                    listeVerbes.add(s);
                }
            }
            process.destroy();

            verbes = listeVerbes.toArray(new String[]{});
            Arrays.sort(verbes, java.text.Collator.getInstance(Locale.FRENCH));

            for (String s : verbes) {
                listModelListeVerbesTous.addElement(s);
            }
            setListeVerbes(listModelListeVerbesTous);
        }
        catch (IOException ex) {
            Logger.getLogger(Verbiste.class.getName()).log(Level.SEVERE, null, ex);
        }

        verbesSansAccent = new String[verbes.length];
        for (int i = 0; i < verbes.length; i++) {
            verbesSansAccent[i] = supprimerAccents(verbes[i]);
        }

        ArrayList<Initiale> listeInitiales = new ArrayList<>();
        Initiale vide = new Initiale(); // pour initialiser listeInitales avec un élément qu'il faudra supprimer
        vide.debut = vide.fin = 0;
        vide.lettre = '0';
        listeInitiales.add(vide);
        for (int i = 0; i < verbesSansAccent.length; i++) {
            char lettre = verbesSansAccent[i].charAt(0);
            if (lettre == listeInitiales.get(listeInitiales.size() - 1).lettre) {
                listeInitiales.get(listeInitiales.size() - 1).fin = i;
            }
            else {
                Initiale initiale = new Initiale();
                initiale.debut = initiale.fin = i;
                initiale.lettre = lettre;
                listeInitiales.add(initiale);
            }
        }
        listeInitiales.remove(0);
        initiales = listeInitiales.toArray(new Initiale[]{});

        int[] widths = buttonTous.getFontMetrics(buttonTous.getFont()).getWidths();
        int max = 0;
        for (int n : widths) {
            if (n > max) {
                max = n;
            }
        }
        max += 4;
        for (int i = 0; i < initiales.length; i++) {
            JToggleButton buttonLettre = new JToggleButton();
            initiales[i].bouton = buttonLettre;
            buttonGroup1.add(buttonLettre);
            buttonLettre.setText("" + initiales[i].lettre);
            panelInitiale.add(buttonLettre);
            buttonLettre.setName("" + i);
            buttonLettre.setFont(buttonTous.getFont());
            Dimension d = buttonLettre.getPreferredSize();
            d.width = max;
            buttonLettre.setPreferredSize(d);
            buttonLettre.addActionListener((java.awt.event.ActionEvent evt) -> {
                buttonTousActionPerformed(evt);
            });
        }

        pack();
    }

    public static class Verbe {

        public enum Mode {
            Indicatif {
                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Présent, Temps.Imparfait, Temps.PasséSimple, Temps.Futur};
                }

                @Override
                String getNomCMD() {
                    return "indicative";
                }

            },
            Conditionnel {
                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Présent};
                }

                @Override
                String getNomCMD() {
                    return "conditional";
                }

            },
            Subjonctif {
                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Présent, Temps.Imparfait};
                }

                @Override
                String getNomCMD() {
                    return "subjunctive";
                }

            },
            Impératif {
                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Présent};
                }

                @Override
                String getNomCMD() {
                    return "imperative";
                }

            },
            Participe {
                @Override
                Temps[] getTemps() {
                    return new Temps[]{Temps.Présent, Temps.Passé};
                }

                @Override
                String getNomCMD() {
                    return "participle";
                }

            };

            Temps[] getTemps() {
                return null;
            }

            String getNomCMD() {
                return null;
            }
        }

        public enum Temps {
            Présent {
                @Override
                String getNomCMD() {
                    return "present";
                }

            },
            Imparfait {
                @Override
                String getNomCMD() {
                    return "imperfect";
                }

            },
            PasséSimple {
                @Override
                public String toString() {
                    return "Passé simple";
                }

                @Override
                String getNomCMD() {
                    return "past";
                }

            },
            Futur {
                @Override
                String getNomCMD() {
                    return "future";
                }

            },
            /**
             * pour le Participe uniquement
             */
            Passé {
                @Override
                String getNomCMD() {
                    return "past";
                }

            },;

            String getNomCMD() {
                return null;
            }
        }

        private java.util.HashMap<String, String[]> conjugaison = new HashMap<>();

        private static BufferedReader sortie;
        private static OutputStreamWriter entree;

        static {
            try {
                String cmd = CMD + " --pronouns ";
                Process process = Runtime.getRuntime().exec(cmd);
                sortie = new BufferedReader(new InputStreamReader(process.getInputStream()));
                entree = new OutputStreamWriter(process.getOutputStream());
            }
            catch (IOException ex) {
                Logger.getLogger(Verbiste.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public Verbe(String verbe) {
            ArrayList<String> list = new ArrayList<>();
            try {
                entree.write(verbe + '\n');
                entree.flush();
                String s;
                boolean participePasséAtteind = false;
                while (!((s = sortie.readLine()).equals("-") && (participePasséAtteind))) {
                    list.add(s);
                    if (s.equals("- " + getNomCMD(Mode.Participe, Temps.Passé) + ":")) {
                        participePasséAtteind = true;
                    }
                }
                list.add(s); // le dernier "-"
            }
            catch (IOException ex) {
                Logger.getLogger(getClass().getName()).log(Level.SEVERE, null, ex);
            }
            for (Mode m : Mode.values()) {
                for (Temps t : m.getTemps()) {
                    int debut = -1, fin = -1;
                    for (int i = 0; i < list.size(); i++) {
                        if (list.get(i).startsWith("- " + m.getNomCMD() + " " + t.getNomCMD())) {
                            if (debut == -1) {
                                debut = i + 1;
                            }
                        }
                        else if ((debut != -1) && (list.get(i).startsWith("-"))) {
                            fin = i - 1;
                            break;
                        }
                    }
                    ArrayList<String> tempsDerivé = new ArrayList<>();
                    for (int i = debut; i <= fin; i++) {
                        tempsDerivé.add(list.get(i));
                    }
                    conjugaison.put(m.getNomCMD() + " " + t.getNomCMD(), tempsDerivé.toArray(new String[]{}));
                }
            }
        }

        public String[] get(Mode mode, Temps temps) {
            return conjugaison.get(getNomCMD(mode, temps));
        }

        public static String getNomFrançais(Mode mode, Temps temps) {
            return mode + " " + temps;
        }

        private static String getNomCMD(Mode mode, Temps temps) {
            return mode.getNomCMD() + " " + temps.getNomCMD();
        }

        public static int getModeTempsLength(Mode mode, Temps temps) {
            if (mode.equals(Mode.Impératif)) {
                return 3;
            }
            if (mode.equals(Mode.Participe) && temps.equals(Temps.Présent)) {
                return 1;
            }
            if (mode.equals(Mode.Participe) && temps.equals(Temps.Passé)) {
                return 4;
            }
            return 6;
        }

        /**
         * Utile pour faire des Map<br>
         * Notament dans le dessin du Panel Conjugaison pour garder une
         * référence de tous les Label (qui sont en fait des JTextField)
         */
        public static class ModeTemps {

            public Mode mode;
            public Temps temps;

            public ModeTemps(Mode mode, Temps temps) {
                this.mode = mode;
                this.temps = temps;
            }

            @Override
            public boolean equals(Object o) {
                if ((o == null) || (!(o instanceof ModeTemps))) {
                    return false;
                }
                ModeTemps mt = (ModeTemps) o;
                return ((mt.mode == mode) && (mt.temps == temps));
            }

            @Override
            public int hashCode() {
                int hash = 7;
                hash = 53 * hash + Objects.hashCode(this.mode);
                hash = 53 * hash + Objects.hashCode(this.temps);
                return hash;
            }
        }
    }

}
